/*
 * Decompiled with CFR 0.152.
 */
package BsscXML;

import BsscXML.BsscXML;
import BsscXML.BsscXMLDocument;
import BsscXML.BsscXMLException;
import BsscXML.BsscXMLTokenizer;
import BsscXML.IBsscXMLConsumer;
import BsscXML.IBsscXMLDocumentBuilder;
import BsscXML.IBsscXMLElementBuilder;
import BsscXML.IBsscXMLParser;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;

public class BsscXMLParser
implements IBsscXMLParser,
Runnable {
    private Stack m_processingElements = null;
    private IBsscXMLDocumentBuilder m_document = new BsscXMLDocument();
    private boolean m_bReady;
    private Reader m_is = null;

    public static String xmlToText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '&') {
                if (n2 + 3 < n && string.charAt(n2 + 1) == 'l' && string.charAt(n2 + 2) == 't' && string.charAt(n2 + 3) == ';') {
                    stringBuffer.append('<');
                    n2 += 3;
                } else if (n2 + 3 < n && string.charAt(n2 + 1) == 'g' && string.charAt(n2 + 2) == 't' && string.charAt(n2 + 3) == ';') {
                    stringBuffer.append('>');
                    n2 += 3;
                } else if (n2 + 5 < n && string.charAt(n2 + 1) == 'q' && string.charAt(n2 + 2) == 'u' && string.charAt(n2 + 3) == 'o' && string.charAt(n2 + 4) == 't' && string.charAt(n2 + 5) == ';') {
                    stringBuffer.append('\"');
                    n2 += 5;
                } else if (n2 + 4 < n && string.charAt(n2 + 1) == 'a' && string.charAt(n2 + 2) == 'm' && string.charAt(n2 + 3) == 'p' && string.charAt(n2 + 4) == ';') {
                    stringBuffer.append('&');
                    n2 += 4;
                } else {
                    stringBuffer.append(string.charAt(n2));
                }
            } else {
                stringBuffer.append(string.charAt(n2));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void parse() {
        if (this.m_is != null) {
            this.parse(this.m_is);
        }
    }

    public void parse(Reader reader) {
        try {
            BsscXMLTokenizer bsscXMLTokenizer = new BsscXMLTokenizer(this);
            bsscXMLTokenizer.tokenize(reader);
            reader.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beginElement(String string) throws BsscXMLException {
        IBsscXMLElementBuilder iBsscXMLElementBuilder = BsscXML.createElement(string);
        if (!this.m_processingElements.empty()) {
            Object e = this.m_processingElements.peek();
            if (!(e instanceof IBsscXMLElementBuilder)) throw new BsscXMLException("Type Mismatch!");
            ((IBsscXMLElementBuilder)e).addChild(iBsscXMLElementBuilder);
            iBsscXMLElementBuilder.setParent((IBsscXMLElementBuilder)e);
        } else {
            if (this.m_document == null) throw new BsscXMLException("Internal Error!");
            this.m_document.setRoot(iBsscXMLElementBuilder);
        }
        this.m_processingElements.push(iBsscXMLElementBuilder);
    }

    public void findValue(String string) throws BsscXMLException {
        Object e = this.m_processingElements.peek();
        if (e instanceof IBsscXMLElementBuilder) {
            String string2 = BsscXMLParser.xmlToText(string);
            ((IBsscXMLElementBuilder)e).setValue(string2);
            return;
        }
        throw new BsscXMLException("Type Mismatch!");
    }

    public void beginDocument() {
    }

    public void endElement(String string) throws BsscXMLException {
        Object e = this.m_processingElements.peek();
        if (e instanceof IBsscXMLElementBuilder) {
            if (((IBsscXMLElementBuilder)e).checkName(string)) {
                this.m_processingElements.pop();
                return;
            }
            throw new BsscXMLException("Bad XML Format!");
        }
        throw new BsscXMLException("Type Mismatch!");
    }

    public BsscXMLParser(IBsscXMLConsumer iBsscXMLConsumer) {
        ((BsscXMLDocument)this.m_document).addConsumer(iBsscXMLConsumer);
        this.m_processingElements = new Stack();
    }

    public void endDocument() throws BsscXMLException {
        if (!this.m_processingElements.empty()) {
            throw new BsscXMLException("Wrong XML Format!");
        }
        this.m_document.setReady(true);
    }

    public void findAttr(String string, String string2) throws BsscXMLException {
        Object e = this.m_processingElements.peek();
        if (e instanceof IBsscXMLElementBuilder) {
            String string3 = BsscXMLParser.xmlToText(string2);
            ((IBsscXMLElementBuilder)e).setAttribute(string, string3);
            return;
        }
        throw new BsscXMLException("Type Mismatch!");
    }

    public void run() {
        this.parse();
    }

    public void setSource(Reader reader) {
        this.m_is = reader;
    }
}

